package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 中止变更数据来源(1-乡镇协管；2-服务管家)
 *
 * @author chuhy
 * @date 2023/3/10 16:10
 */
@AllArgsConstructor
@Getter
public enum StopDataSourceEnums {


    XZXG(1, "乡镇协管"),

    FWGJ(2, "服务管家");

    private final Integer code;

    private final String name;

    public static String getNameByCode(Integer code) {
        Optional<StopDataSourceEnums> stopTypeEnums = Arrays.stream(StopDataSourceEnums.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (stopTypeEnums.isPresent()) {
            return stopTypeEnums.get().getName();
        }
        return "无";
    }
}
