package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import java.util.Objects;

public enum PickupCountSourceEnum {
	declare("申报数据",1),
	reportInfo("评估报告编辑数据",2),
	riskInfo("职业病危害因素接触一览表",3),
	supervise("监管认定",4),
	none("无依据",5),

	;

	// 成员变量
	private String name;
	private Integer code;
	// 构造方法

	private PickupCountSourceEnum(String name, Integer code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Integer code) {
		if (code == null) {
			return null;
		}
		for (PickupCountSourceEnum c : PickupCountSourceEnum.values()) {
			if (Objects.equals(c.getCode(), code)) {
				return c.name;
			}
		}
		return null;
	}
	
	// 普通方法
	public static Integer getCodeByName(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (PickupCountSourceEnum c : PickupCountSourceEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getCode();
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
}
