package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 巡查分级(0-无；1-无危害；2-一般；3-较重；4-严重)
 */
@AllArgsConstructor
@Getter
public enum CompanyinspectionClassificationEnum {

    NO("无", 0),
    NO_HARM("无危害", 1),
    GENERAL("一般", 2),
    HEAVY("较重", 3),
    SEVERITY("严重", 4),
    ;

    private String name;
    private Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (CompanyinspectionClassificationEnum c : CompanyinspectionClassificationEnum.values()) {

            if (Objects.equals(c.getValue(), value)) {
                return c.name;
            }
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (name == null) {
            return null;
        }
        for (CompanyinspectionClassificationEnum c : CompanyinspectionClassificationEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }
}
