package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * 企业类型（1-用人单位,2-外包单位,3-用人兼外包单位）
 */
public enum CompanyTypeEnum {

    ONE("用人单位", 1),
    TWO("外包单位", 2),
    THIRD("用人兼外包单位", 3),
    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private CompanyTypeEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    // 普通方法
    public static String getName(Boolean code) {
        if (code == null) {
            return "用人单位";
        }
        for (CompanyTypeEnum c : CompanyTypeEnum.values()) {
            if (Objects.equals(c.getCode(), code)) {
                return c.name;
            }
        }
        return "用人单位";
    }

    // 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (CompanyTypeEnum c : CompanyTypeEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
