package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 企业入库原因枚举
 */
@AllArgsConstructor
@Getter
public enum CompanyStorageReasonEnum {
    
    
    //申报导入1,举报投诉2,法定上报3,其他涉案4,其他原因-安装在线监测/监控企业

    DECLARATIONIMPORT("申报导入",1),
    REPORTCOMPLAINTS("举报投诉",2),
    STATUTORYREPORTING("法定上报",3),
    OTHERCASESINVOLVED("其他涉案",4),
    OTHERREASONS_INSTALLONLINEMONITORING("其他原因-安装在线监测/监控企业",5)
    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (CompanyStorageReasonEnum c : CompanyStorageReasonEnum.values()) {

            if (Objects.equals(c.getValue(), value)) {
                return c.name;
            }
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (name == null) {
            return null;
        }
        for (CompanyStorageReasonEnum c : CompanyStorageReasonEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }
}
