package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import java.util.Objects;

public enum CompanyOccTypeEnum {
	SERIOUS("严重",0),
	HEAVIER ("较重",1),
	COMMON("一般",2),
	NOTSUBDIVIDED("未细分",3),
	UNDIVIDED("行业无分类",4),

	;

	// 成员变量
	private String name;
	private Integer code;
	// 构造方法

	private CompanyOccTypeEnum(String name, Integer code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Integer code) {
		if (code == null) {
			return null;
		}
		for (CompanyOccTypeEnum c : CompanyOccTypeEnum.values()) {
			if (Objects.equals(c.getCode(), code)) {
				return c.name;
			}
		}
		return "未划分";
	}
	
	// 普通方法
	public static Integer getCodeByName(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (CompanyOccTypeEnum c : CompanyOccTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getCode();
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
}
