package cn.smarthse.modules.datacentre.enums;

/**
 * 企业是否申报
 */
public enum CompanyIsReportEnum {

    DECLARED("已申报", Boolean.TRUE),
    NODECLARED("未申报", Boolean.FALSE),
    ;

    private String name;
    private Boolean value;

    public static Boolean getValueByName(String name) {
        if (name == null) {
            return null;
        }
        for (CompanyIsReportEnum c : CompanyIsReportEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }

    public static String getNameByValue(Boolean value) {
        if (value == null) {
            return "未申报";
        }
        for (CompanyIsReportEnum c : CompanyIsReportEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return "未申报";
    }

    CompanyIsReportEnum(String name, Boolean value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getValue() {
        return value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }
}