package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * 企业是否示范
 */
public enum CompanyIsBestEnum {

    TRUE("是", Boolean.TRUE),
    FALSE("否", Boolean.FALSE),
    ;

    // 成员变量
    private String name;
    private Boolean code;
    // 构造方法

    private CompanyIsBestEnum(String name, Boolean code) {
        this.name = name;
        this.code = code;
    }

    // 普通方法
    public static String getName(Boolean code) {
        if (code == null) {
            return "否";
        }
        for (CompanyIsBestEnum c : CompanyIsBestEnum.values()) {
            if (Objects.equals(c.getCode(), code)) {
                return c.name;
            }
        }
        return "否";
    }

    // 普通方法
    public static Boolean getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (CompanyIsBestEnum c : CompanyIsBestEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getCode() {
        return code;
    }

    public void setCode(Boolean code) {
        this.code = code;
    }
}
