package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyDelReasonEnum
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 33
 * @since 2021/5/24-16:33
 */
public enum CompanyDelReasonEnum {
    NOOUTCOMPANY("非外包单位",1),
    NOCOMPANY("非用人单位",2),
    REPEAT ("重复数据",3),
    TEST("测试数据",4),
    OTHER("其他",9),

    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private CompanyDelReasonEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }
    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (CompanyDelReasonEnum c : CompanyDelReasonEnum.values()) {
            if (Objects.equals(c.getCode(), code)) {
                return c.name;
            }
        }
        return null;
    }

    // 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (CompanyOccTypeEnum c : CompanyOccTypeEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }
}
