package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 企业数据来源虚拟
 */
@AllArgsConstructor
@Getter
public enum CompanyDataSourceVirtuallyEnum {

    /**
     * is_regulation_visible = 0
     * 其它来源（培训未分类 + 东阳市职业卫生管理系统未分类 + 新建企业未分类） = 所有 - 浙里卫企
     */
    OTHER("其它来源", 1),
    /**
     * is_regulation_visible = 0 and data_source != 5
     * 其它来源（除培训外的所有未分类） = 所有 - 浙里卫企 - 在线培训
     */
    OTHER2("其它来源", 2),

    //=====================================================================

    /**
     * is_regulation_visible = 1
     * 浙里卫企 = 所有 - 培训未分类 - 东阳市职业卫生管理系统未分类 - 新建企业未分类
     */
    ZLWQ("浙里卫企", 0),
    /**
     * is_regulation_visible = 0 and data_source = 5
     * 或
     * is_dec = 0 and data_source = 5
     */
    OLINETRAIN("在线培训", 5),
    /**
     * is_regulation_visible = 0 and data_source = 10
     * 或
     * is_dec = 0 and data_source = 10
     */
    DONG_YANG_SYSTEMS("东阳市职业卫生管理系统", 10),
    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (CompanyDataSourceVirtuallyEnum c : CompanyDataSourceVirtuallyEnum.values()) {

            if (Objects.equals(c.getValue(), value)) {
                return c.name;
            }
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (name == null) {
            return null;
        }
        for (CompanyDataSourceVirtuallyEnum c : CompanyDataSourceVirtuallyEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }
}
