package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 企业数据来源
 */
@AllArgsConstructor
@Getter
public enum CompanyDataSourceEnum {

    PLATFORM("平台", 1),
    SUPERVISE("监管系统", 2),
    WAITSURE("待确认企业", 3),
    CLASSIFSUPERVICE("分类监督", 4),
    OLINETRAIN("在线培训", 5),
    CHUANGDE("创得", 6),
    WANDA_DECLARE("万达申报", 7),
    THIRD_FWGJ("服务管家", 8),
    DECLARE_20240203("2024年2月23日申报导入", 9),
    DONG_YANG_SYSTEMS("东阳市职业卫生管理系统", 10),
    NEW_COMPANY_GUIDE("新建企业引导", 11),

    DECLARE_20240730("2024年7月30日申报导入", 12),
    /** 以后申报数据导入的企业就用这个数据源 **/
    DECLARE_IMPORT("申报企业导入", 13),
    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (CompanyDataSourceEnum c : CompanyDataSourceEnum.values()) {

            if (Objects.equals(c.getValue(), value)) {
                return c.name;
            }
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (name == null) {
            return null;
        }
        for (CompanyDataSourceEnum c : CompanyDataSourceEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }
}
