package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyBusinessState
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 12
 * @since 2019/12/19-14:12
 */
public enum CompanyBusinessState {

    NORMAL("正常营业", 1),
    STOP("暂停营业", 2),
    CLOSE("已关闭", 0),
    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private CompanyBusinessState(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return "已关闭";
        }
        for (CompanyBusinessState c : CompanyBusinessState.values()) {
            if (Objects.equals(c.getCode(), code)) {
                return c.name;
            }
        }
        return "已关闭";
    }

    // 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (CompanyBusinessState c : CompanyBusinessState.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
