package cn.smarthse.modules.datacentre.enums;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyBelongTypeEnum
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 14
 * @since 2020/11/2-15:14
 */
public enum CompanyBelongTypeEnum {

    NO("否", 0),
    SHENG("省属", 1),
    SHI("市属", 2),
    ;

    // 成员变量
    private String name;
    private Integer value;

    // 构造方法
    private CompanyBelongTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public static Integer getValueByName(String name) {
        if (name == null) {
            return null;
        }
        for (CompanyBelongTypeEnum c : CompanyBelongTypeEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "否";
        }
        for (CompanyBelongTypeEnum c : CompanyBelongTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return "否";
    }
}
