package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyBaseChangeType
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 40
 * @since 2023/6/29-16:40
 */
@AllArgsConstructor
@Getter
public enum CompanyBaseChangeTypeEnum {

    /**
     * 接害人数变化（实际人数）
     */
    PICKUPCOUNT("接害人数变化（实际人数）", 1),
    /**
     * 接害人数变化（监管认定）
     */
    PICKUPCOUNT_VICTIMS("接害人数变化（监管认定）", 3),
    /**
     * 行政区划变更
     */
    AREA_CHANGE("行政区划变更", 4),
    /**
     * 行业职业病危害风险类别
     */
    OCCTYPE_CHANGE("行业职业病危害风险类别", 5),
    /**
     * 企业名称变更
     */
    COMPANY_NAME_CHANGE("企业名称变更", 6),
    /**
     * 营业状态变更
     */
    BUSINESS_STATE_CHANGE("营业状态变更", 7),
    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return "";
        }
        for (CompanyBaseChangeTypeEnum c : CompanyBaseChangeTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return "";
    }
}
