package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyBaseChangeType
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 40
 * @since 2023/6/29-16:40
 */
@AllArgsConstructor
@Getter
public enum CompanyBaseChangeChangeCaseEnum {

    ADD("增加", 1),
    REMOVE("移除", 2),
    NO("无变化", 3),
    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return "";
        }
        for (CompanyBaseChangeChangeCaseEnum c : CompanyBaseChangeChangeCaseEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return "";
    }
}
