package cn.smarthse.modules.datacentre;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

public @Data class JqGridParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 是否是搜索请求
     */
    private boolean _search = false;

    /**
     * 用于排序的列名
     */
    private String sidx;

    /**
     * 排序的方式 asc desc
     */
    private String sord;

    /**
     * 过滤属性
     */
    private String filters;

    /**
     * 总页数
     */
    private long total;
    /**
     * 页码
     */
    private int page;
    /**
     * 记录数
     */
    private long records;
    /**
     * 每页几条记录
     */
    private int rows;

    // 自定义的参数，企业编号
    private Long cid;

    // 自定义的参数，id
    private Long id;

    // 自定义的参数，外键id
    private Long keyId;

    // 自定义的参数，阶段
    private Byte stage;

    // 自定义的参数，状态
    private Byte state;

    // 自定义的参数，年份
    private String years;

    // 自定义的参数，开始时间
    private Date beginTime;

    // 自定义的参数，结束时间
    private Date endTime;

    /**
     * 职业监管系统用户的登录的id
     */
    private Long loginUserId;
    /**
     * 职业监管系统用户的登录的组织id
     */
    private Long orgId;
    /**
     * 是否查询总数
     */
    private Boolean count = Boolean.TRUE;

    private String keyword;

    public JqGridParam() {
        this.rows = 10;
        this.page = 1;
    }

    public JqGridParam(int rows, int page) {
        this.rows = rows;
        this.page = page;
    }

    public static enum sordType {
        asc, desc
    }

    public static enum operType {
        eq, like, notEq, isNull, notNull, in
    }

}
