package cn.smarthse.modules.datacentre;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

//1.按照JqGrid的格式定义一个bean
public class JqGridData<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 总页数
     */
    private long total;
    /**
     * 页码
     */
    private long page;
    /**
     * 记录数
     */
    private long records;
    /**
     * 数据实体
     */
    private List<T> rows;

    public JqGridData() {
    }

    public JqGridData(PageInfo<T> rows, JqGridParam param) {
        if (rows != null && param.getRows() > 0) {
            if (rows.getTotal() % param.getRows() == 0) this.total = rows.getTotal() / param.getRows();
            else this.total = rows.getTotal() / param.getRows() + 1;
            this.page = param.getPage();
            this.records = rows.getTotal();
            this.rows = rows.getList();
        }
    }

    public JqGridData(Page<T> rows, JqGridParam param) {
        if (rows != null && param.getRows() > 0) {
            if (rows.getTotal() % param.getRows() == 0) {
                this.total = rows.getTotal() / param.getRows();
            } else {
                this.total = rows.getPages(); //总页数
            }
            this.page = param.getPage(); //页码
            this.records = rows.getTotal(); //总数
            this.rows = rows;
        }
    }

    /**
     * 分页
     */
    public JqGridData(List<T> allList, JqGridParam param) {

        int page = param.getPage();
        int size = param.getRows();
        this.page = page;
        if (allList == null) {
            allList = new LinkedList<>();
        }
        this.total = allList.size() / size;
        if (allList.size() % size != 0) {
            this.total += 1;
        }
        this.records = allList.size();
        List<T> l = new LinkedList<>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); i++) {
            l.add(allList.get(i));
        }
        this.rows = l;
    }

    public List<T> getRows() {
        return rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public long getRecords() {
        return records;
    }

    public void setRecords(Integer records) {
        this.records = records;
    }

    public long getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

}
