package cn.smarthse.modules.common.util;


import cn.smarthse.modules.datacentre.model.apps.NoiseCalcuModel;

public class NoiseCalcuUtil {

	//private static Logger logger = LogManager.getLogger(NoiseCalcuUtil.class);

	public static NoiseCalcuModel calcu(NoiseCalcuModel model) {
		
		//logger.info("《噪声计算工具》-计算全天等效声级 LAeqT ,开始!");
		
		NoiseCalcuModel m = splitArray(model.getLaeqts(),model.getTs());
		
		Double[] lAeqTs = m.getLaeqt();
		Double[] T = m.getT();
		
		Double sum = 0.0;
		Double tSum = 0.0;
		for (int i = 0; i < T.length; i++) {
			tSum += T[i];
			//logger.info("T[i]:{},tSum:{}",T[i],tSum);
			sum += (Math.pow(10,0.1*lAeqTs[i])*T[i]);
		}
		
		Double LAeqT = 10 * Math.log10(sum/tSum);
		Double T0 = 8.0;
		//logger.info("《噪声计算工具》-总数sum:{},总时间tSum:{}",sum,tSum);
		if (tSum > 24) {
			//logger.info("总时间tSum>24,无效!");
		}
		//logger.info("《噪声计算工具》-计算全天等效声级 LAeqT:{} ,完成!",LAeqT);
		
		//logger.info("《噪声计算工具》-规格化-计算8h等效声级 LEX8h ,开始!");
		Double Te = tSum;
		//logger.info("《噪声计算工具》-实际一天工作时间:{}",Te);
		Double LEX8h = LAeqT + 10 * Math.log10(Te/T0);
		//logger.info("《噪声计算工具》-规格化-计算8h等效声级 LEX8h:{},完成!",LEX8h);
		
		Double De = model.getDe();
		//logger.info("《噪声计算工具》-实际一周工作时间:{}",De);
		//logger.info("《噪声计算工具》-规格化-计算工作5天(40h)的等效声级 LEX40h ,开始!");
		Double LEX40h =10 * Math.log10(Math.pow(10, 0.1 * LEX8h)*De/5.0);
		//logger.info("《噪声计算工具》-规格化-计算工作5天(40h)等效声级 LEX40h:{},完成!",LEX40h);
		
		model.setLEX8h(LEX8h);
		model.setLEX40h(LEX40h);
		return model;
	}
	
	public static String check(NoiseCalcuModel model) {
		//logger.info("《噪声计算工具》-校验数据!");
		String content=null;
		
		if (model == null) {
			content = "参数为空，无法计算!";
			return content;
		}
		
		if (model.getLaeqts()==null || model.getTs() == null) {
			content = "参数不全，无法计算!";
			return content;
		}
		NoiseCalcuModel m = splitArray(model.getLaeqts(),model.getTs());
		
		Double[] lAeqT = m.getLaeqt();
		Double[] T = m.getT();
		Double Te = 0.0;
		for (int i = 0; i < T.length; i++) {
			Te += T[i];
		}

		if (lAeqT==null || T==null) {
			content = "参数不全，无法计算!";
			return content;
		}
		Boolean isNull = true;
		Double tSum = 0.0;
		for (int i = 0; i < lAeqT.length; i++) {
			if (lAeqT[i]!=null && T[i]!=null) {
				isNull = false;
				tSum += T[i];
			}
		}
		if (isNull==true) {
			content = "参数不全，无法计算!";
			return content;
		}
		
		if (tSum>24) {
			content = "请填写有效的接触场所时间!";
			return content;
		}
		
		
		if (Te>24) {
			content = "每天实际工作时间数值不合法,请重新填写!";
			return content;
		}
		if (model.getDe()==null) {
			content = "请填写每周实际工作时间!";
			return content;
		}
		if (model.getDe()>7) {
			content = "每周实际工作时间数值不合法,请重新填写!";
			return content;
		}
		//logger.info("《噪声计算工具》-数据校验成功!");
		return content;
		
	}
	
	private static NoiseCalcuModel splitArray(String laeqts,String ts) {
//		CacuLaeqtModel[] cacuLaeqt = model.getCacuLaeqt();
//		
//		if (cacuLaeqt==null) {
//			throw new RuntimeException("无有效数据,计算失败!!");
//		}
//		Integer index = 0;
//		//循环遍历查询有效数据
//		for (int i = 0; i < cacuLaeqt.length; i++) {
//			
//			if (cacuLaeqt[i].getLaeqt()!=null && cacuLaeqt[i].getT()!=null) {
//				
//				index ++;
//			}
//			
//		}
//		
//		if (index == 0) {
//			throw new RuntimeException("无有效数据,计算失败!!");
//		}else {
//			logger.info("有效数据为"+index+"条!");
//		}
//		
//		Double[] lAeqTs = new Double[index];
//		Double[] T = new Double[index];
//		
//		Integer j = 0;
//		for (int i = 0; i < cacuLaeqt.length; i++) {
//			
//			if (cacuLaeqt[i].getLaeqt()!=null && cacuLaeqt[i].getT()!=null) {
//				lAeqTs[j] = cacuLaeqt[i].getLaeqt();
//				T[j] = cacuLaeqt[i].getT();
//				j++;
//			}
//			
//		}
//		
//		NoiseCalcuModel m = new NoiseCalcuModel();
//		m.setLaeqt(lAeqTs);
//		m.setT(T);
		
		String[] laeqtstr = laeqts.split(",");
		String[] tstr = ts.split(",");
		
		Integer index = 0;
		if (laeqtstr.length == tstr.length) {
			for (int i = 0; i < tstr.length; i++) {
				if (laeqtstr[i]!=null && tstr[i]!=null) {
					index ++;
				}
			}
		}
		
		if (index == 0) {
			throw new RuntimeException("无有效数据,计算失败!!");
		}else {
			//logger.info("有效数据为"+index+"条!");
		}
			
		Double[] lAeqTs = new Double[index];
		Double[] T = new Double[index];
		
		Integer j = 0;
		if (laeqtstr.length == tstr.length) {
			for (int i = 0; i < tstr.length; i++) {
				if (laeqtstr[i]!=null && tstr[i]!=null) {
					lAeqTs[j] = Double.valueOf(laeqtstr[i]);
					T[j] =  Double.valueOf(tstr[i]);
					j++;
				}
			}
		}
		
		NoiseCalcuModel m = new NoiseCalcuModel();
		
		m.setLaeqt(lAeqTs);
		m.setT(T);
		return m;
		
	}
}
