package cn.smarthse.modules.common.model;

import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * @program:
 * @description:
 * @author: yzp
 * @create: 2021/1/26 8:36
 */
@Data
public class TrainCompanyModel implements Serializable {

    /**
     * 公司id
     */
    private Long id;

    /**
     * 员工id
     */
    private Long staffId;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 所在行政区域
     */
    private String areaName;

    /**
     * 行业分类
     */
    private String industryCategory;

    /**
     * 企业规模
     */
    private String scale;

    /**
     * 企业规模字符串
     */
    private String scaleStr;

    /**
     * 本年度全部主要负责人考试状态(逗号隔开)
     */
    private String mainStaff;

    /**
     * 本年度主要负责人考试状态字符串
     */
    private String mainStaffStr;

    /**
     * 本年度全部职业卫生管理员考试状态(逗号隔开)
     */
    private String adminStaff;

    /**
     * 本年度职业卫生管理员考试状态字符串
     */
    private String adminStaffStr;

    /**
     * 本年度劳动者数量
     */
    private String workerCount;

    public String getScaleStr(){
        if (scale != null){
            if (scale.equals("1") || scale.equals("2")){
                return scaleStr = scale.equals("1") ? "大型企业" : "中型企业";
            }else {
                return scaleStr = scale.equals("3") ? "小型企业" : "微型企业";
            }
        }
        return scaleStr;
    }

    public String getMainStaffStr(){
        return examState(mainStaff, mainStaffStr);
    }

    public String getAdminStaffStr(){
        return examState(adminStaff, adminStaffStr);
    }

    private String examState(String examStates, String result){
        if (!StringUtils.isEmpty(examStates)){
            String[] split = examStates.split(",");
            List<String> examStateList = Arrays.asList(split);
            if (examStateList.contains("1")){
                return result = "已考试，合格";
            }
            if (examStateList.contains("2")){
                return result = "已考试,不合格";
            }
            return result = "未考试";
        }
        return result;
    }


}
