/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.util;

import cn.smarthse.modules.platform.model.PayHeader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;

public class PaySignUtil {
    public static final String SUCCESS_CHAR = "SUCCESS";
    public static final String yyyyMMddHHmm = "yyyyMMddHHmm";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";

    public static String buildPayHeaderSign(PayHeader payHeader, String API_KEY) {
        TreeMap<String, Object> parms = new TreeMap<String, Object>();
        parms.put("nonce_str", payHeader.getNonce_str());
        parms.put("appid", payHeader.getAppid());
        String sign = PaySignUtil.createSign(parms, API_KEY);
        return sign;
    }

    public static boolean verifyPayHeaderSign(PayHeader payHeader, String key) {
        String createSign = PaySignUtil.buildPayHeaderSign(payHeader, key);
        return createSign.equals(payHeader.getSign());
    }

    public static String createSign(SortedMap<String, Object> packageParams, String key) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, Object>> es = packageParams.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String k = entry.getKey();
            String v = (String)entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=").append(key);
        String sign = DigestUtils.md5Hex((byte[])PaySignUtil.getContentBytes(sb.toString(), "UTF-8"));
        return sign;
    }

    public static boolean verifySign(Map<Object, Object> map, String key) {
        TreeMap<String, Object> parameterMap = new TreeMap<String, Object>();
        String sign = (String)map.get("sign");
        for (Object keyValue : map.keySet()) {
            if (keyValue.toString().equals("sign")) continue;
            parameterMap.put(keyValue.toString(), map.get(keyValue));
        }
        String createSign = PaySignUtil.createSign(parameterMap, key);
        return createSign.equals(sign);
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static String create_nonce_str() {
        String currTime = PaySignUtil.getStringDateTime(yyyyMMddHHmmss);
        String strRandom = String.valueOf(PaySignUtil.buildRandom(4));
        return currTime + strRandom;
    }

    public static String getStringDateTime(String dateFormat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static int buildRandom(int length) {
        int num = 1;
        double random = Math.random();
        if (random < 0.1) {
            random += 0.1;
        }
        for (int i = 0; i < length; ++i) {
            num *= 10;
        }
        return (int)(random * (double)num);
    }

    public static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

