/**
 * 
 */
package cn.smarthse.modules.platform.toC.model;

/**
 * 《用户第三方登录类型定义》
 * <li>公司全系统统一定义
 * 
 * @Project:  smarthse-common1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-20-上午9:41:46
 */
public enum UserThirdTypeEnum {
	//(0-平台,1-手机,2-邮箱,3-微信,4-...)
	/** 平台 */
	platform("平台",(byte) 0, "platform"),
	/** 手机 */
	mobile("手机",(byte) 1,"mobile"),
	/** 邮箱 */
	email("邮箱",(byte) 2,"email"),
	/** 微信开放平台 */
	weixin("微信",(byte) 3,"weixin"),
	/** 微信公众平台 */
	mp_weixin("微信公众平台",(byte) 4,"mp_weixin"),
	/** 个推 */
	gexin_token("个推",(byte) 5,"gexin_token"),
	/** 融云 */
	rongcloud_token("融云",(byte) 6,"rongcloud_token"),
	/** 身份证 */
	IDCARD_token("身份证",(byte) 7,"idcard_token"),
	;
	// 成员变量
	private String name;
	private byte type;
	private String bindType;
	// 构造方法
	
	private UserThirdTypeEnum(String name, byte type, String bindType) {
		this.name = name;
		this.type = type;
		this.bindType = bindType;
	}

	// 普通方法
	public static UserThirdTypeEnum getBindType(String bindType) {
		for (UserThirdTypeEnum c : UserThirdTypeEnum.values()) {
			if (c.getBindType().equals(bindType)) {
				return c;
			}
		}
		return null;
	}
	
	
	
	//===================变量 Get/Set===================
	
	
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the type
	 */
	public byte getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(byte type) {
		this.type = type;
	}

	/**
	 * @return the bindType
	 */
	public String getBindType() {
		return bindType;
	}

	/**
	 * @param bindType the bindType to set
	 */
	public void setBindType(String bindType) {
		this.bindType = bindType;
	}

		
}
