package cn.smarthse.modules.platform.provider;

import cn.smarthse.modules.common.model.WechatMessage;
import cn.smarthse.modules.platform.model.wechat.ExpressTemlateModel;
import cn.smarthse.modules.platform.model.wechat.merchant.WxTemplateResult;



public interface IWechatService{  
	
	
	/**
	 * 添加需发送的消息
	 * @param adminIds
	 * @param remindMsg
	 * @return 
	 */
	public String addWechatMessage(WechatMessage wechatMessage);
	
	
	
	/**
	 * 发送模板消息
	 * @return 返回0为发送成功，暂定发送失败为1x
 	 * @param userId 接受用户的userid
	 * @param content 发送的内容
	 */
	public int sendTemlate(long userId, String content);
	
	/**
	 * 带跳转URL的推送消息
	 * @param userId
	 * @param content
	 * @param jumpUrl
	 * @return
	 */
	public int sendTemlate(long userId, String content, String jumpUrl);
	
	/**
	 * 快递消息推送接口
	 * @param expressModel
	 * @return
	 */
	public WxTemplateResult sendTemlate(ExpressTemlateModel expressModel);
	
	
	
}
