/**
 * 
 */
package cn.smarthse.modules.platform.provider;


import java.util.List;

import cn.smarthse.modules.platform.model.UserCertificationModel;
import cn.smarthse.modules.platform.model.UserLoginBindModel;
import cn.smarthse.modules.platform.model.UserModel;
import cn.smarthse.modules.platform.model.UserWeixinModel;
import cn.smarthse.modules.platform.toC.model.UserThirdModel;
import cn.smarthse.modules.platform.toC.model.UserThirdTypeEnum;

/**
 * 《平台用户接口》
 * 
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午3:30:20
 */
public interface IPUserService {

	/**
	 * 注册平台账号
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月4日-上午8:28:58
	 * @param model
	 * @return	平台用户Id
	 */
	Long registerUser(UserModel model);
	
	/**
	 * 第三方用户注册
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午3:52:06
	 * @param model			注册数据
	 * @param userThird			第三方数据包
	 * @return	Long			平台用户Id
	 */
	Long registeredByThird(UserModel model, UserThirdModel userThird);
	
	/**
	 * 根据Key查询用户基础信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午9:28:43
	 * @param key
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModelBase(String key) ;
	
	/**
	 * 根据Key查询用户信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月11日-上午9:59:14
	 * @param key	用户名,手机,邮箱,openid,等第三方绑定表的token
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModel(String key);
	
	/**
	 * 根据Key查询用户信息
	 * <li> 2018/05/28 增加获取用户信息时,读取包含用户个人认证数据接口 edit by shao TO 健康顾问2.2
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月11日-上午9:59:14
	 * @param key	用户名,手机,邮箱,openid,等第三方绑定表的token
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModelWithUserCertification(String key);
	
	/**
	 * 处理用户绑定
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午4:20:20
	 * @param userThird
	 * @return	Integer		
	 */
	Integer processUserBindLogin(UserThirdModel userThird);
	
//	TODO　平台实名认证流程需变更
	/**
	 * 处理用户提交实名认证信息
	 * <li>平台已有提交信息时,ServiceException异常,C端自己处理
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午9:46:31
	 * @param certificationModel	认证信息
	 * @return	<li>0: 	未成功提交认证信息,可能平台有个人认证处理
	 * 			<li>1:	成功提交
	 * @throws ServiceException
	 */
	@Deprecated
	Integer processUserCertification(UserCertificationModel certificationModel) ;
	
	/**
	 * 根据平台Id查询平台认证信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午11:35:59
	 * @param userId
	 * @return	null:表示无认证信息(未认证)
	 */
	@Deprecated
	UserCertificationModel getUserCertificationModelByUserId(Long userId);
	
	
	/**
	 * 验证用户名与密码是否正确
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月6日-下午2:11:33
	 * @param username		用户名
	 * @param md5password	密码(md5)
	 * @return
	 */
	Boolean verifyPassword(String username, String md5password);
	
	/**
	 * 通过手机号码获取用户微信信息(基础)
	 * <li>基础信息仅包含openid,昵称,头像
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年8月13日-下午1:47:10
	 * @param mobile
	 * @return
	 */
	UserWeixinModel getUserWeixinModelByMobile(String mobile);
	
	/**
	 * 批量查询用户微信信息(基础)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年8月13日-下午1:48:31
	 * @param mobileList
	 * @return
	 */
	List<UserWeixinModel> getUserWeixinModelByMobile(List<String> mobileList);
	
	
	/**
	 * 根据userId/Token读取用户绑定信息
	 * <b>userId/Token	二选一
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-22-上午11:39:53
	 * @param userId		用户Id
	 * @param token			Token值
	 * @param bindLogin		绑定类型
	 * @return UserLoginBindModel
	 */
	UserLoginBindModel getUserLogin(Long userId, String token, UserThirdTypeEnum bindLogin);
	
	
	/**
	 * 读取 平台用户是否绑定了身份证,并返回绑定信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年8月20日-上午11:20:40
	 * @param userId		平台用户Id
	 * @return
	 */
	UserLoginBindModel getUserIDCard(Long userId);
	
	/**
	 * 绑定 平台用户+身份证
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年8月20日-上午11:20:40
	 * @param userId		平台用户Id
	 * @param IDCard		身份证
	 * @param fullname		真实姓名
	 * @return
	 */
	UserLoginBindModel bindUserIDCard(Long userId, String IDCard, String fullname);
	
}
