/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 《企业基础信息接口》
 * 
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午4:17:15
 */
public @Data class CorpInfoModel implements Serializable{
	private static final long serialVersionUID = -8683247781523757541L;

	/**
	 * 平台企业ID
	 */
	 private Long corpId;
	 
	 /**
     * 企业名称、医疗机构名称
     */
    private String fullname;

    /**
     * 企业简称
     */
    private String shortname;

    /**
     * 企业编号串(社会统一信代码/登记号/组织代码)
     */
    private String corpCc;
    
    /**
     * 联系人
     */
    private String corpApplyName;
    
    /**
     * 联系人电话
     */
    private String corpApplyMobile;
    
    /**
     * 注册时间
     */
    private Date regeditDate;
    
    /**
     * 格式化数据
     * 注册时间
     */
    private String regeditDateFormatter;
    
    /**
     * 联系电话
     */
    private String corpTel;
    
    /**
     * 企业邮箱
     */
    private String corpEmail;
    
    /**
     * 企业注册行政区域
     */
    private Long corpAreaId;
    
    /**
     * 通讯地址
     */
    private String corpAddress;
    
    /**
     * 所属行业Id
     * 
     * <li>1.3版本增加 by  shao
     */
    private Long corpTypeId;
    
    /**
     * 所属行业
     * <li>1.3版本增加 by  shao
     */
    private String corpTypeName;
    
    /**
     * 企业软件最后的购买时间
     * <li>2.2版本增加 by shao, @see:cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.promocode有关
     */
    private CorpSoftModel corpSoftModel;
}
