/**
 * 
 */
package cn.smarthse.modules.platform.enums;

/**
 * 《支付结果定义》
 * 
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-24-下午3:36:27
 */
public enum PayStateEnum {

	/**
	 * 待支付
	 */
	pay_ing("未付款", (byte) 0),
	/**
	 * 支付完成
	 */
	pay_success("已付款", (byte) 1),
	/**
	 * 支付失败
	 */
	pay_fail("未收到金额", (byte) 2),
	/**
	 * 支付取消
	 */
	pay_cancel("取消订单", (byte) 3),
	
	;
	
	// 成员变量
	private Byte state;
	private String value;

	// 构造方法
	private PayStateEnum(String value, Byte state) {
		this.state = state;
		this.value = value;
	}
	
	// 普通方法
	public static PayStateEnum getPayStateEnum(Byte state) {
		if (state == null) {
			return null;
		}
		for (PayStateEnum c : PayStateEnum.values()) {
			if (c.getState().equals(state)) {
				return c;
			}
		}
		return null;
	}
	
	

	// get set 方法

	/**
	 * @return the state
	 */
	public Byte getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Byte state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
}
