/**
 * 
 */
package cn.smarthse.modules.platform.enums;


/**
 * 《企业软件日志状态枚举类》
 * 
 * 
 * @Project: platform-facade
 * @Module ID: <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used: <JDK1.7>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-17-下午3:35:44
 */
public enum CorpSoftLogStateEnum {

	/**
	 * 待处理
	 */
	pending("待处理", (byte) 0),
	/**
	 * 通过
	 */
	success("通过", (byte) 1),
	/**
	 * 不通过
	 */
	fail("不通过", (byte) 2);

	// 成员变量
	private Byte state;
	private String value;

	// 构造方法
	private CorpSoftLogStateEnum(String value, Byte state) {
		this.state = state;
		this.value = value;
	}
		
	// 普通方法
	public static String getValue(Byte state) {
		if (state == null) {
			return null;
		}
		for (CorpSoftLogStateEnum c : CorpSoftLogStateEnum.values()) {
			if (c.getState().equals(state)) {
				return c.value;
			}
		}
		return null;
	}

	// get set 方法

	/**
	 * @return the state
		*/
	public Byte getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Byte state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

}
