package cn.smarthse.modules.logistics.provider;

import com.github.pagehelper.PageInfo;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.logistics.model.GiianOrder;

/**
 * 建安快递系统对外接口
 */
public interface IGiianLogisticsService {

	/**
	 * 根据手机号获取用户订单列表
	 * 
	 * @param mobile
	 *            手机号
	 * @param paramModel
	 *            分页相关参数
	 */
	public PageInfo<GiianOrder> getUserOrderList(String mobile, PageParamModel paramModel);
	
	/**
	 * 根据手机号获取用户详情（姓名、单位、手机号、微信头像）
	 * 
	 * @param mobile
	 *            手机号
	 * @param paramModel
	 *            分页相关参数
	 */
	public GiianOrder getUserInfo(String mobile);
	
	
	/**
	 * 用户解绑
	 *  @param openid  微信用户的标识，对当前公众号唯一
	 */
	public void UnBindUser(String openid);
}
