/**
 * 
 */
package cn.smarthse.modules.hospitaldevice.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 《2.4.2.	个人剂量模型(MonitorModel)》
 * <p>若为True时，调查结论与处理意见需要传递；
 * <p>如果此次个人剂量监测结果该人员属于异常人员（PS系统该人员自动生成了一条大剂量调查记录）则显示此按钮/文本，否则不显示。如果大剂量调查未完成，显示文本“请及时进行大剂量调查”，如果已完成，则显示按钮“查看大剂量调查结果”

 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-12-21-下午1:55:38
 */
public @Data class MonitorModel implements Serializable {
	private static final long serialVersionUID = -987783051895731714L;

	/**
	 * 开始年月	String	格式(YYYY-MM-DD)
	 */
	private Date startDate;
	
	/**
	 * 结束年月	String	格式(YYYY-MM-DD),无则显示“至今”
	 */
	private Date endDate;
	
	/**
	 * 本次监测结果	String	检测结果+单位合并显示
	 */
	private String monitorResult;
	
	/**
	 * 是否异常	0:否 1:是，若是1，则显示大剂量调查结果按钮，
	 */
	private Byte isException;
	
	/**
	 * 调查结论	String	
	 */
	private String surveyResult;
	
	/**
	 * 处理意见
	 */
	private String surveyHandle;
	
	/**
	 * 调查状态 1：未完成 2：已完成 3：已终止
	 */
	private Byte status;
	
	/**
	 * 开始时间
	 */
	private String start = "";
	
	/**
	 * 结束时间
	 */
	private String end = "";
	
}
