package cn.smarthse.modules.health.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public @Data class HHealthCheckModel implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3405210239247916410L;

	private Long healthCheckId; //体检信息id
	
    private Long staffId;   //员工id

    private String checktypeName; // 职业健康监护种类；
    
    private String checkType;//体检类型

    private Date startDate; // 体检时间

    private Date endDate; // 体检时间

    private List<HHealthCheckConclusionModel> conclusionList; //体检详细信息
    
    private String checkName = null; // 其他疾病或异常 页面判断

	public String getCheckName() {
		if(conclusionList.size() == 1){
			if("其他疾病或异常".equals(conclusionList.get(0).getExamresults())){
				if(null == checkName || "".equals(checkName)){
					checkName = "其他疾病或异常";
				}
			}
		}
		return checkName;
	}

	private void setCheckName() {
		
	}
    
    
}
