package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: ICompanyProvideBySuperviseService
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 53
 * @since 2019/6/12-14:53
 */
public interface ICompanyProvideBySuperviseService {

    public PageInfo<CompanySuperviseModel> pageCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo, int pageNum, int pageSize);

    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo);

    public CompanySuperviseModel getCompanyInfoById(Long id);


    public List<CompanySuperviseModel> listCompanyByName(String name);

    public CompanySuperviseModel saveImportCompany(CompanySuperviseModel company, Long loginStaffId);

    public CompanySuperviseModel updateCompany(CompanySuperviseModel company, Long loginStaffId);

    /**
     * @Comments:  <企业删除>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/26-16:52
     * @param ids
     * @return int
    */
    public int delCompanyByIds(String ids);
    /**
     * @Comments:  <设置示范企业>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/7/25-11:00
     * @param ids
     * @return int
    */
    public int bestCompanyByIds(String ids, Long loginUser);
    /**
     * @Comments:  <取消示范企业>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/7/25-11:00
     * @param cid
     * @return int
    */
    public int cancelBestCompany(Long cid, Long loginUser);


    public PageInfo<CompanySuperviseModel> pageCompanyByBest(Long areaId, Boolean isBest, int pageNum, int pageSize);
}
