package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;

import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: ICompanyProvideByHSEService
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 57
 * @since 2019/6/12-14:57
 */
public interface ICompanyProvideByHSEService {

    /**
     * @Comments:  <根据ID获取 企业基本信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/12-15:29
     * @param id
     * @return Company
    */
    public CompanyBaseInfoModel getCompanyById(Long id);

    /**
     * @Comments:  <职业健康系统  企业信息保存>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/12-16:24
     * @param companyModel
     * @param loginStaffId
     * @param cid
     * @return cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel
    */
    public CompanyBaseInfoModel saveOrUpdateCompany(CompanyBaseInfoModel companyModel, Long loginStaffId, Long cid) throws Exception;

    /**
     * @Comments:  <监管统计 数据接口>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/28-9:10
     * @param 
     * @return java.util.List<cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel>
    */
    public List<CompanySuperviseModel> listSuperviseCompanyData();

    public Integer countSuperviseCompanyData();

    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize);

}
