package cn.smarthse.modules.platform.toC.provider;

import cn.smarthse.modules.platform.toC.model.UserThirdModel;
import cn.smarthse.modules.platform.toC.model.UserThirdTypeEnum;

/**
 * 
 * 《平台用户第三方信息接口声明》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年3月8日-上午10:05:08
 */
public interface IUserThirdService {

	/**
	 * 根据OpenId读取用户绑定信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年3月8日-上午10:06:36
	 * @param OpenId	微信绑定Token
	 * @return
	 * @exception		ServiceException 异常
	 */
	UserThirdModel getUserThirdByToken(String OpenId);
	
	/**
	 * 根据用户Id与第三方类型获取Token
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年3月21日-下午4:06:30
	 * @param userId			平台用户Id
	 * @param thirdType			第三方类型枚举类
	 * @return
	 */
	String getUserThirdToken(Long userId, UserThirdTypeEnum thirdType);

	/**
	 * 查询OpenId对应的微信信息JSON
	 * <li>JSON对应数据 包：cn.smarthse.common.framework.tencent.weixin.vo.UserUnionInfo
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月13日-上午8:54:26
	 * @param openId
	 * @return
	 */
	String getWeixinUserInfo(String openId);
	
}
