/**
 * 
 */
package cn.smarthse.modules.kafka.model;

import lombok.Data;


/**
 * 《个人提醒消息》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年11月9日-上午9:31:47
 */
public @Data class UserRemindModel extends KafkaBaseModel {
	private static final long serialVersionUID = -61092016116749183L;

	/**
	 * 发布对象
	 */
	private Long toUserId;
	
	/**
     * 标题
     */
    private String msgTitle;
	
    /**
     * 类别来源（1-平台消息）
     */
    private Integer msgResource;
    
    /**
     * 消息分类(1-系统消息，2-放辐射软件微信推送消息,3-职业健康软件微信推送消息）
     * @see cn.smarthse.modules.platform.enums.sys.RemindMessageEnum
     */
    private Integer msgType;
    /**
     * 消息地址
     */
    private String msgUrl;
    /**
     * 主体内容
     */
    private String msgContent;
}
