package cn.smarthse.modules.healthadvisor.model;

import java.io.Serializable;
import java.util.Date;

import cn.smarthse.modules.healthadvisor.enums.TicketSourceEnum;
import cn.smarthse.modules.healthadvisor.enums.TicketTypeStateEnum;
import lombok.Data;

/**
 * 
 * 《UserTicket》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:
 * @Comments:  <用户健康券分配>
 * @JDK version used:      <JDK1.8> 
 * @author gbx
 * @since 2018-1-02-上午10:13:09
 */
public @Data class UserAddTicket implements Serializable {
	
	/**
	 * 企业id
	 */
	private Long cid;
	
	/**
	 * 健康顾问用户id
	 */
	private Long haUserId;
	
	/**
	 * 到期时间
	 */
	private Date edate;
	
	/***
	 * 分配数量
	 */
	private Integer number;
	
	/**
	 * 类型
	 */
	private TicketTypeStateEnum type;
	
	
	/**
	 * 健康券来源 (默认 平台赠送)
	 */
	private TicketSourceEnum ticketSource = TicketSourceEnum.www; 
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    
	
}