/**
 * 
 */
package cn.smarthse.modules.datacentre.provider;

import java.util.List;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyListModel;
import cn.smarthse.modules.datacentre.model.CompanyRegInfoModel;
/**
 * 《数据中心企业服务接口声明》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年5月30日-下午1:39:38
 */
public interface ICompanyProvideService {

	/**
	 * 根据企业Id， 读取企业信息Id
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年5月30日-下午1:40:22
	 * @param cid
	 * @return
	 */
	CompanyBaseInfoModel getCompanyBaseInfoById(Long cid);
	
	
	/**
	 * 检测企业全称验证企业是否已被注册，若已存在，则返回企业model
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午4:15:50
	 * @param name	企业全称
	 * @param cid	排除企业Id
	 * @return	true : 未注册 ,   false: 已被注册 
	 */
	CompanyBaseInfoModel getBycompanyName(String name, Long cid);
	
	/**
	 * 检测企业全称验证企业是否已被注册，若已存在，则返回企业model
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午4:15:50
	 * @param name	企业全称
	 * @param cid	排除企业Id
	 * @return	true : 未注册 ,   false: 已被注册 
	 */
	Boolean checkBycompanyName(String name, Long cid);
	
	
	/**
	 * 根据社会统一信用代码查询企业是否已被注册
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年5月30日-下午4:33:20
	 * @param unifiedSocialCc	社会统一信贷码	： 社会信用代码
	 * @param cid				企业编号 		: 排除编号 
	 * @return	true : 未注册 ,   false: 已被注册 
	 */
	Boolean checkByUnifiedSocialCc(String unifiedSocialCc,Long cid);
	
	
	/**
	 * 根据企业联系邮箱查询实体(已存在表示该邮箱已被使用)
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-27-上午9:55:24
	 * @param email
	 * @return	企业编号
	 */
	Long getCidByEmail(String email);
	/**
	 * 根据企业联系邮箱查询实体(已存在表示该邮箱已被使用)
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-27-上午9:55:24
	 * @param email
	 * @return	CompanyBaseInfoModel
	 */
	CompanyBaseInfoModel getByEmail(String email, Long cid);
	/**
	 * 根据企业联系邮箱查询实体(已存在表示该邮箱已被使用)
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-27-上午9:55:24
	 * @param email
	 * @param cid	排除企业Id
	 * @return	true : 未注册 ,   false: 已被注册 
	 */
	Boolean checkByEmail(String email, Long cid);
	
	/**
	 * 变更企业邮箱
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年6月3日-上午10:19:55
	 * @param cid			企业Id
	 * @param email			电子邮箱
	 * @param emailCheck	邮箱状态
	 * @param userId		操作员Id
	 */
	void updateCompanyEmail(Long cid, String email, Integer emailCheck, Long userId);
	
	
	/**
	 * 注册企业(待认证状态)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年5月30日-下午4:36:23
	 * @param regInfo
	 * @param createBy
	 * @return
	 */
	CompanyBaseInfoModel createCompanyByPlatform(CompanyRegInfoModel regInfo);
	
	
	/**
	 * 更新企业基础信息(平台更新）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年5月30日-下午3:58:46
	 */
	void updateCompanyBaseInfoByPlatform(CompanyBaseInfoModel baseInfo, Long updateBy);
	
	/**
	 * 获取企业名
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年6月3日-上午8:48:42
	 * @param cid
	 * @return
	 */
	String getFullnameBycid(Long cid);


	/**
	 * 根据词来源:fullname,shortname,corp_cc
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年7月3日-上午9:45:03
	 * @param searchKey	多关键词搜索词,多个用|隔开,详细查看mysql regexp: @example 企业|111
	 * @return
	 */
	List<CompanyListModel> searchList(String searchKey);
	
}
