/**
 * 
 */
package cn.smarthse.modules.datacentre.model;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《数据中心企业基础信息ListModel》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年5月30日-下午1:32:37
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CompanyListModel implements Serializable {
	private static final long serialVersionUID = -798554499553566968L;

	@ApiModelProperty(value="企业编号, 与 cid同值")
	private Long id;
    
    @ApiModelProperty(value="行政区域详情：原始存放的编号")
    private Long areaId;

	/**
	 * fullname企业名称
	 */
    @ApiModelProperty(value="fullname企业名称")
	private String name;
	/**
	 * 企业名称简称
	 */
    @ApiModelProperty(value="企业名称简称")
	private String shortName;
    
    /**
    * corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
	 */
    @ApiModelProperty(value="corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）")
	private String unifiedSocialCc;
	
}
