/**
 * 
 */
package cn.smarthse.modules.datacentre.enums;

import com.google.common.base.Objects;


/**
 * 《治理行业分类P-Code生成枚举》
 * 	 * @serialField	B060 00 1: 井工煤矿  -> B06-地下
	 * @serialField	B060 00 2: 露天媒矿  -> B06-地上
	 * @serialField	BXX0 00 1: 非煤地下矿山  -> B07~11-地下
	 * @serialField	BXX0 00 2: 非煤地下矿山  -> B07~11-地上
	 * @serialField	C310 00 0: 黑色金额冶炼  
	 * @serialField	C320 00 0: 有色金额冶炼  
	 * @serialField	C251 00 0: 炼油 
	 * @serialField	C260 00 0: 化工 
	 * @serialField	C200 00 0: 木材加工和木、竹、藤、棕、草制品业
	 * @serialField	C210 00 0: 家具制造业
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年6月12日-上午9:13:32
 */
public enum GovernIndustryCategoryParentCodeEnum {
	B06("井工煤矿", "B06", "B06"),
	B07("石油和天然气开采业", "B07", "BXX"),
	B08("黑色金属矿采选业", "B08", "BXX"),
	B09("有色金属矿采选业", "B09", "BXX"),
	B10("非金属矿采选业", "B10", "BXX"),
	B11("开采专业及辅助性活动", "B11", "BXX"),
	C20("木材加工和木、竹、藤、棕、草制品业", "C20", "C20"),
	C21("家具制造业", "C21", "C21"),
	C251("炼油", "C251", "C251"),
	C31("黑色金额冶炼", "C31", "C31"),
	C32("有色金额冶炼", "C32", "C32"),
	
	;
	// 成员变量
	private String industryCategoryName;
	private String industryCategoryPrefix;
	private String industryCategoryPrefixCode;

	// 构造方法
	private GovernIndustryCategoryParentCodeEnum(String industryCategoryName
			, String industryCategoryPrefix
			, String industryCategoryPrefixCode
			
			
			) {
		this.industryCategoryName = industryCategoryName;
		this.industryCategoryPrefix = industryCategoryPrefix;
		this.industryCategoryPrefixCode = industryCategoryPrefixCode;
	}

	// 普通方法
	public static String getIndustryCategoryParentCode(String industryCategoryCode, Boolean isIndustryCategoryB) {
		StringBuffer pCode = new StringBuffer();
		GovernIndustryCategoryParentCodeEnum ce = null;
		if(industryCategoryCode!=null && industryCategoryCode.length()>0) {
			for (GovernIndustryCategoryParentCodeEnum c : GovernIndustryCategoryParentCodeEnum.values()) {
				//找到了配置项
				if(industryCategoryCode.indexOf(c.getIndustryCategoryPrefix())>=0) {
					ce = c;
					break;
				}
			}
		}
		
		
		if(ce == null ) {
			//无配置项,取前3位
			if(industryCategoryCode!=null && industryCategoryCode.length() > 3) {
				pCode.append(industryCategoryCode.substring(0, 3)).append("000");
			}else {
				pCode.append(industryCategoryCode);
			}
			
		}else {
			pCode.append(ce.getIndustryCategoryPrefixCode());
			if(ce.getIndustryCategoryPrefix().length() == 3) {
				pCode.append("00");
			}else if(ce.getIndustryCategoryPrefix().length() ==4) {
				//特殊c251
				pCode.append("0");
			}
			
			if(isIndustryCategoryB == null) {
				pCode.append("0");
			}else if(isIndustryCategoryB) {
				//true=地下
				pCode.append("1");
			}else {
				//false=地上
				pCode.append("2");
			}
		}
		
		return pCode.toString();
	}

	
	
	
	
	
	
	
	// get set 方法
	
	public String getIndustryCategoryName() {
		return industryCategoryName;
	}

	public void setIndustryCategoryName(String industryCategoryName) {
		this.industryCategoryName = industryCategoryName;
	}

	public String getIndustryCategoryPrefix() {
		return industryCategoryPrefix;
	}

	public void setIndustryCategoryPrefix(String industryCategoryPrefix) {
		this.industryCategoryPrefix = industryCategoryPrefix;
	}

	public String getIndustryCategoryPrefixCode() {
		return industryCategoryPrefixCode;
	}

	public void setIndustryCategoryPrefixCode(String industryCategoryPrefixCode) {
		this.industryCategoryPrefixCode = industryCategoryPrefixCode;
	}
	

	
	
	
}
