package cn.smarthse.modules.datacentre.enums;

import org.springframework.util.StringUtils;

import com.google.common.base.Objects;

public enum CompanySizeEnum {
	Large("大型企业",1),
	Medium ("中型企业",2),
	Small("小型企业",3),
	Micro("微型企业",4),
	
	; 
	
	// 成员变量
	private String name;
	private Integer code;
	// 构造方法

	private CompanySizeEnum(String name, Integer code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Integer code) {
		if (code == null) {
			return null;
		}
		for (CompanySizeEnum c : CompanySizeEnum.values()) {
			if (Objects.equal(c.getCode(), code)) {
				return c.name;
			}
		}
		return null;
	}
	
	// 普通方法
	public static Integer getCodeByName(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (CompanySizeEnum c : CompanySizeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getCode();
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
}
