/**
 * 
 */
package cn.smarthse.modules.datacentre.enums;


/**
 * 《企业邮箱换绑状态枚举类》
 * (0-未绑定,1-已发送绑定信息,2-已绑定,3-超时)
 * 
 * @Project: platform-facade
 * @Module ID: <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used: <JDK1.7>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-17-下午3:35:44
 */
public enum CompanyEmailEnum {

	/**
	 * 0-未绑定
	 */
	bound_un("未绑定",  0),
	/**
	 * 1-已发送绑定信息
	 */
	bound_unverified("未验证",  1),
	/**
	 * 2-已绑定
	 */
	bound_ok("已绑定",  2),
	/**
	 * 3-不通过变更
	 */
	bound_no("不通过变更",  3);
	// 成员变量
	private Integer state;
	private String value;

	// 构造方法
	private CompanyEmailEnum(String value, Integer state) {
		this.state = state;
		this.value = value;
	}

	// get set 方法

	/**
	 * @return the state
	 */
	public Integer getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Integer state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

}
