package cn.smarthse.modules.common.model;

import java.io.Serializable;

import cn.smarthse.modules.common.enums.HospitalModuleEnum;
import lombok.Data;

/**
 * 
 * 《ModuleInformation》
 * 
 * 
 * @Project: GIIANTECH CORE
 * @Module ID:
 * @Comments: <企业模块操作信息>
 * @JDK version used: <JDK1.7>
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2018-1-02-上午10:13:09
 */
public @Data class ModuleInformation implements Serializable {

	/**
	 * 模块名称
	 */
	private String moduleName;

	/**
	 * 操作次数
	 */
	private Integer moduleOperationTotal;

	private static final long serialVersionUID = 1L;

	public ModuleInformation() {

	}

	public ModuleInformation(HospitalModuleEnum module, Integer count) {
		this.moduleName = module.getModuleName();
		this.moduleOperationTotal = count;
	}
}