/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.platform.sys;

import java.util.List;

import cn.smarthse.modules.platform.sys.model.SysFile;


 /**
 * 
 * 《平台附件Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-07-08 02:44
 */
public interface ISysFileService {
	
	/**
	 * 根据ID获取单条数据
	 * @param id
	 * @return
	 */
	SysFile getById(Long id);
	
	/**
	 * 根据文件Id获得文件全路径地址
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年10月10日-下午3:36:20
	 * @param fileId
	 * @return
	 */
	String getFileUrlByfid(Long fileId);
	
	/**
	 * 根据用户MD5读取附件信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年10月10日-下午5:03:53
	 * @param filehash		文件Hash码
	 * @return
	 */
	SysFile getFileByHash(String filehash);
	
	/**
	 * 根据用户MD5读取附件信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-10-下午4:34:05
	 * @param loginUserId
	 * @param filehash
	 * @return
	 */
	SysFile getFileByUserId(Long loginUserId, String filehash);
	
	/**
	 * 新增数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午3:49:17
	 * @param entity
	 * @return
	 */
	SysFile add(SysFile entity);
	
	/**
	 * 保存数据（必须带有关键字段）
	 * @param entity
	 * @return	更新成功条数
	 */
	Integer update(SysFile entity);
	
	/**
	 * 保存数据（必须带有关键字段）
	 * @param entity
	 * @param updateBy 更新用户Id
	 * @return	更新成功条数
	 */
	Integer update(SysFile entity,Long updateBy);
	
	/**
	 * 更新全部数据(包含NULL字段)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-3-下午1:34:50
	 * @param entity
	 * @param updateBy	updateBy 更新用户Id
	 * @return	更新成功条数
	 */
	Integer updateByPrimaryKey(SysFile entity,Long updateBy);
	
	/**
	 * 逻辑删除
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-28-上午9:52:30
	 * @param entity
	 * @param updateBy	updateBy 更新用户Id
	 * @return	删除成功条数
	 */
	Integer delete(SysFile entity,Long updateBy);
	
	/**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     *
     * @param ids 如 "1,2,3,4"
     * @return
     */
	List<SysFile> getListByIds(String ids);
	


}
