/**
 * 
 */
package cn.smarthse.modules.platform.model.apps;

/**
 * 《体检类型 枚举类》
 * 上岗前职业健康检查-1    在岗期间职业健康检查-2    应急健康检查-3    离岗后健康检查-5     离岗时健康检查-4
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年1月5日-下午4:35:18
 */
public enum OccupationHealthTypeOccupationalMedicalEnum {
	A1("上岗前职业健康检查", "1"),
	A2("在岗期间职业健康检查", "2"),
	A3("应急健康检查", "3"),
	A4("离岗时健康检查", "4"),
	A5("离岗后健康检查", "5"),
	;
	// 成员变量
	private String name;
	private String type;
	/**
	 * 构造方法
	 * @param name			检查项名称
	 * @param type			检查项Type
	 * @param requiredItem	是否必检项目
	 * @param chooseItem	是否选检项目
	 */
	private OccupationHealthTypeOccupationalMedicalEnum(String name, String type) {
		this.name = name;
		this.type = type;
	}
	//
	public static OccupationHealthTypeOccupationalMedicalEnum getTypeEnum(String type) {
		if (type == null) {
			return null;
		}
		
		for (OccupationHealthTypeOccupationalMedicalEnum c : values()) {
			if (c.getType().equals(type)) {
				return c;
			}
		}
		return null;
	}
	
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
}
