/**
 * 
 */
package cn.smarthse.modules.platform.model.apps;

/**
 * 《检查项目 枚举类》
 检查对象 1  
目标疾病_2  
职业禁忌证_3  
职业病_4  
检查内容_5  
症状询问_6 
 体格检查_7  
必检项目_8  
选检项目_9  
复查对象_10 
 复查内容_11  
健康检查周期_12  
检查时间_13 
 医学观察_14  
流行病学调查_15  
体检鉴定结论_16
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年1月4日-上午11:24:41
 */
public enum OccupationHealthNameExaminationEnum {
	A1("检查对象", 1, false, false),
	A2("目标疾病", 2, false, false),
	A3("职业禁忌证", 3, false, false),
	A4("职业病", 4, false, false),
	A5("检查内容", 5, false, false),
	A6("症状询问", 6, false, false),
	A7("体格检查", 7, false, false),
	A8("必检项目", 8, true, false),
	A9("选检项目", 9, false, true),
	A10("复查对象", 10, false, false),
	A11("复查内容", 11, false, false),
	A12("健康检查周期", 12, false, false),
	A13("检查时间", 13, false, false),
	A14("医学观察", 14, false, false),
	A15("流行病学调查", 15, false, false),
	A16("体检鉴定结论", 16, false, false),
	
	;

	// 成员变量
	private String name;
	private Integer type;
	private Boolean requiredItem, chooseItem;
	/**
	 * 构造方法
	 * @param name			检查项名称
	 * @param type			检查项Type
	 * @param requiredItem	是否必检项目
	 * @param chooseItem	是否选检项目
	 */
	private OccupationHealthNameExaminationEnum(String name, Integer type, Boolean requiredItem, Boolean chooseItem) {
		this.name = name;
		this.type = type;
		this.requiredItem = requiredItem;
		this.chooseItem = chooseItem;
	}
	//
	public static OccupationHealthNameExaminationEnum getName(Integer type) {
		if (type == null) {
			return null;
		}
		
		for (OccupationHealthNameExaminationEnum c : values()) {
			if (c.getType().equals(type)) {
				return c;
			}
		}
		return null;
	}
	
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getType() {
		return type;
	}
	public void setType(Integer type) {
		this.type = type;
	}
	public Boolean getRequiredItem() {
		return requiredItem;
	}
	public void setRequiredItem(Boolean requiredItem) {
		this.requiredItem = requiredItem;
	}
	public Boolean getChooseItem() {
		return chooseItem;
	}
	public void setChooseItem(Boolean chooseItem) {
		this.chooseItem = chooseItem;
	}
			
			
	
	
}
