/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * 《企业软件接口》
 * 
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午4:17:31
 */
public @Data class CorpSoftModel implements Serializable{
	private static final long serialVersionUID = -1034588436667064566L;

	/**
	 * 平台企业ID
	 */
	 private Long corpId;
	 
	/**
	 * 企业软件ID
	 */
	private Long corpSoftId;
	
	/**
     * 软件名称(冗余)
     */
    private String softName;
    
    /**
     * 开始时间
     */
    private Date sdate;

    /**
     * 结束日期
     */
    private Date edate;
    
    /**
     * 版本设定编号
     */
    @Deprecated
    private String softVersion;
    
    
    /**
     * 版本名
     */
    @Deprecated
    private String softVersionName;
    
    /**
     *   软件KEY
     */
    private String softkey;
    

    /**
     *   软件密钥(RSA，用于软件验证时加密参数)
     */
    private String softsecure;
    
    
    /**
     * 套餐空间数,单位按G,默认20G
     */
    private Integer comboSpaceCount;

    /**
     * 套餐用户数,默认1
     */
    private Integer comboUserCount; 
    
    /**
     * 订单提交时间
     * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.payCreateDate
     */
    private Date orderDate;
    
    /**
	 * 状态	包括已付款和未付款
	 * 处理状态（0-未付款，1-已付款，2-未收到金额，3-取消订单）
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.checkState
	 */
	private Byte payState;
    
    /**
	 * 付款金额（元）	未付款的金额显示“—”
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.payCost
	 */
	private BigDecimal payCost; 
	
	/**
	 * 用于 职业健康 APP 登录时需要用户对应的Token
	 */
	private String userToken;
}
