/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.beans.Transient;
import java.io.Serializable;

import com.github.pagehelper.util.StringUtil;

import lombok.Data;
import org.springframework.util.StringUtils;

/**
 * 《行政区域共享数据定义》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月4日-上午8:57:20
 */
public @Data class AreaModel implements Serializable{
	private static final long serialVersionUID = 4601005338041387080L;

	/**
     * ID
     */
    private Long id;

    /**
     * 父编号
     */
    private Long parentId;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 名称
     */
    private String name;

    /**
     * 简拼
     */
    private String py;

    /**
     * 全拼
     */
    private String pyFull;

    /**
     * 经度
     */
    private String lng;

    /**
     * 纬度
     */
    private String lat;

    /**
     * 级别(0-国家,1-省,2-市,3-区,4-乡,5-村)
     */
    private Byte level;

    /**
     * 热度
     */
    private Integer orderBy;

    /**
     * 省编号
     */
    private Long provinceId;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 市编号
     */
    private Long cityId;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 区域ID
     */
    private Long areaId;

    /**
     * 区域名称
     */
    private String areaName;

    /**
     * 乡镇街道编号
     */
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    private String streetName;
    
    @Transient
    public String getFullname() {
    	StringBuffer fullnames = new StringBuffer();
    	if(StringUtil.isNotEmpty(provinceName) && !"null".equalsIgnoreCase(provinceName)) {
    		fullnames.append(provinceName);
    	}
    	
    	if(StringUtil.isNotEmpty(cityName) && !"null".equalsIgnoreCase(cityName)) {
    		fullnames.append(cityName);
    	}
    	
    	if(StringUtil.isNotEmpty(areaName) && !"null".equalsIgnoreCase(areaName)) {
    		fullnames.append(areaName);
    	}
    	
    	if(StringUtil.isNotEmpty(streetName) && !"null".equalsIgnoreCase(streetName)) {
    		fullnames.append(streetName);
    	}
    	
    	return fullnames.toString();
    }


    @Transient
    public String getFullname(String separator) {
        StringBuffer result = new StringBuffer();
        //provinceName cityName areaName streetName
        //省
        if(StringUtils.hasText(this.getProvinceName())){
            result.append(this.getProvinceName()); //.append("/");
        }
        //市
        if(StringUtils.hasText(this.getCityName())){
            result.append(separator);
            result.append(this.getCityName()); //.append("/");
        }
        //区县
        if(StringUtils.hasText(this.getAreaName())){
            result.append(separator);
            result.append(this.getAreaName()); //.append("/");
        }
        //街道
        if(StringUtils.hasText(this.getStreetName())){
            result.append(separator);
            result.append(this.getStreetName()); //.append("/");
        }

        return result.toString();
    }


    @Transient
    public String getShortfullname() {
    	StringBuffer fullnames = new StringBuffer();
    	if(StringUtil.isNotEmpty(provinceName) && !"null".equalsIgnoreCase(provinceName)) {
    		fullnames.append(provinceName.replace("省", ""));
    	}
    	
    	if(StringUtil.isNotEmpty(cityName) && !"null".equalsIgnoreCase(cityName)) {
    		fullnames.append(cityName.replace("市", ""));
    	}
    	
    	if(StringUtil.isNotEmpty(areaName) && !"null".equalsIgnoreCase(areaName)) {
    		fullnames.append(areaName.replace("区", "").replace("县", ""));
    	}
    	
    	if(StringUtil.isNotEmpty(streetName) && !"null".equalsIgnoreCase(streetName)) {
    		fullnames.append(streetName);
    	}
    	
    	return fullnames.toString();
    }
}
