/**
 * 
 */
package cn.smarthse.modules.platform.enums;

/**
 * 《软件定义》
 * 
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-25-上午9:12:46
 */
public enum SoftEnum {
	/**
	 * 职业健康管理系统
	 */
	health(1l, "职业健康安全管理系统", "health", "healthCorpService", "2"),
	
	/**
	 * 放射卫生&辐射安全管理系统
	 */
	hospital(2l, "放射卫生&辐射安全管理系统", "hospital", "hospitalDeviceCorpService", "1"),
	
	/**
	 * 健康顾问(微信版)
	 */
	healthAdvisor_weixin(3l, "健康顾问", "healthAdvisor", "healthAdvisorService", "weixin-1.0"),
	
	/**
	 * 职业健康集团版
	 */
	supervisebloc(4l, "职业健康管理集团解决方案", "supervisebloc", "superviseBlocService", "1"),
	
	;

	// 成员变量
	private Long softId;						//软件编号
	private String name;						//软件名称
	private String nameEn;					//软件英文名
	private String serviceInterface;		//平台与软件IShareCorpService Bean名,可根据SpringContextHolder.getBean获取
	private String serviceVersion;		//版本号
	

	// 构造方法
	private SoftEnum(Long softId, String name, String nameEn, String serviceInterface, String serviceVersion) {
		this.softId = softId;
		this.name = name;
		this.nameEn = nameEn;
		this.serviceInterface = serviceInterface;
		this.serviceVersion = serviceVersion;
	}

	// get set 方法
	/**
	 * @return the softId
	 */
	public Long getSoftId() {
		return softId;
	}

	/**
	 * @param softId the softId to set
	 */
	public void setSoftId(Long softId) {
		this.softId = softId;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the nameEn
	 */
	public String getNameEn() {
		return nameEn;
	}

	/**
	 * @param nameEn the nameEn to set
	 */
	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	/**
	 * @return the serviceInterface
	 */
	public String getServiceInterface() {
		return serviceInterface;
	}

	/**
	 * @param serviceInterface the serviceInterface to set
	 */
	public void setServiceInterface(String serviceInterface) {
		this.serviceInterface = serviceInterface;
	}

	
	/**
	 * @return the serviceVersion
	 */
	public String getServiceVersion() {
		return serviceVersion;
	}

	/**
	 * @param serviceVersion the serviceVersion to set
	 */
	public void setServiceVersion(String serviceVersion) {
		this.serviceVersion = serviceVersion;
	}

	/**
	 * 通过软件ID与对应版本号,读取软件定义
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-27-下午1:59:14
	 * @param softId						软件ID
	 * @param serviceVersion			软件版本号
	 * @return
	 */
	public static SoftEnum getBySoftId(Long softId, String serviceVersion) {
		for(SoftEnum softEnum : SoftEnum.values()){
			if(softEnum.getSoftId().equals(softId) && softEnum.getServiceVersion().equals(serviceVersion)){
				return softEnum;
			}
		}
		return null;
	}
	
	/**
	 * 通过软件ID读取软件枚举定义
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月26日-下午3:44:19
	 * @param softId
	 * @return
	 */
	public static SoftEnum getBySoftId(Long softId) {
		for(SoftEnum softEnum : SoftEnum.values()){
			if(softEnum.getSoftId().equals(softId)){
				return softEnum;
			}
		}
		return null;
	}



}
