package cn.smarthse.modules.logistics.model;

import java.io.Serializable;

import lombok.Data;

/**
 * 快递订单信息
 */
public @Data class GiianOrder implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 快递内容
	 */
	private String orderContent;

	/**
	 * 快递公司
	 */
	private String orderCompany;

	/**
	 * 快递单号
	 */
	private String orderNo;

	/**
	 * 收件人微信头像
	 */
	private String userIcon;

	/**
	 * 收件人所在单位
	 */
	private String userDept;

	/**
	 * 收件人姓名
	 */
	private String realName;

	/**
	 * 收件人手机号
	 */
	private String mobile;

	/**
	 * 发件人姓名
	 */
	private String senderName;

	/**
	 * 发件人手机号
	 */
	private String senderMobile;

}