package cn.smarthse.modules.datacentre.model.system;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.modules.datacentre.model.stat.CompayParamStatModel;
import cn.smarthse.modules.datacentre.model.stat.CompayParamStatModel.CompayParamStatModelBuilder;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 
 * 《系统参数表》
 * {"id":1,"name":"制造业", code: "C" ,"level":0,"isLeaf":false,"expanded":true,"caoz":""}, 
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-18-上午9:16:16
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public  class SysParamTreeModel extends SysParamModel implements Serializable {
	private static final long serialVersionUID = -6661191610982049064L;
	
	//节点的级别，默认最高级为0
    @ApiModelProperty(value="treeGrid属性: 层级")
    private Integer level;
    
    //是否为叶节点，为true时表示该节点下面没有子节点了
    @ApiModelProperty(value="treeGrid属性: 是否子叶")
    private Boolean isLeaf;
    
    //是否默认展开状态
    @ApiModelProperty(value="treeGrid属性: 是否展开")
    private Boolean expanded;
    
    @ApiModelProperty(value="treeGrid属性: 是否已经加载过子节点（为false时点击节点会自动加载子节点）")
    private Boolean loaded;
    
    @ApiModelProperty(value="treeGrid属性: 图标")
    private String icon;

}