package cn.smarthse.modules.datacentre.model.system;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * 《系统参数表》
 * 
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-18-上午9:16:16
 */
public @Data class SysParamModel implements Serializable {
	private static final long serialVersionUID = -6661191610982049064L;

	/**
     * ID
     */
    @ApiModelProperty(value="系统参数id")
    private Long id;

    /**
     * 父Id
     */
    @ApiModelProperty(value="系统参数父Id")
    private Long parentId;

    /**
     * (参数分组，用于取所有数据）
     */
    @ApiModelProperty(value="参数分组")
    private String paramGroup;

    /**
     * 参数编码
     */
    @ApiModelProperty(value="参数编码")
    private String paramCode;

    /**
     * 参数值
     */
    @ApiModelProperty(value="参数值")
    private String paramValue;

    /**
     * 参数描述
     */
    @ApiModelProperty(value="参数描述")
    private String description;

}