/**
 * 
 */
package cn.smarthse.modules.datacentre.model.stat;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《危害因素统计Model》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年6月19日-下午3:35:03
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class HagardStatModel implements Serializable {
	private static final long serialVersionUID = 297254337423367477L;
	@ApiModelProperty(value="上级名称")
	private String parentName;
	
	@ApiModelProperty(value="上级区域Id")
	private Long parentId;
	
	//label: '行政区域名称',name: 'areaName'
	@ApiModelProperty(value="行政区域编号")
	private Long areaId;
		
	//label: '行政区域名称',name: 'areaName'
	@ApiModelProperty(value="行政区域名称")
	private String areaName;
	//label: '企业总数',name: 'companyCount'
	@ApiModelProperty(value="企业总数")
	private Long companyCount;
	
	//教育培训情况
	@ApiModelProperty(value="职工总人数")
	private Long staffCount;
//	{label: '已培训人数',name: 'trainedCount',width: 60},
	@ApiModelProperty(value="已培训人数")
	private Long trainedCount;
//	{label: '培训率',name: 'trainedRate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="培训率, 带2位小数")
	private String trainedRate;
	
	//危害因素接触情况
//	{label: '接触的危害因素名称',name: 'touch_name',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="接触的危害因素名称")
	private String touch_name;
//	{label: '存在该危害企业数',name: 'touch_companyCount',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="存在该危害企业数")
	private Long touch_companyCount;
//	{label: '接触率',name: 'touch_rate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="接触率, 带2位小数")
	private String touch_rate;
//	{label: '已申报企业数',name: 'touch_declare_companyCount',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="已申报企业数")
	private Long touch_declare_companyCount;
//	{label: '申报率',name: 'touch_declare_rate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="申报率, 带2位小数")
	private String touch_declare_rate;
	
	//职业病危害因素检测
//	{label: '已检测企业数',name: 'check_companyCount',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="已检测企业数")
	private Long check_companyCount;
//	{label: '检测率',name: 'check_rate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="检测率, 带2位小数")
	private String check_rate;
//	{label: '检测点位数',name: 'check_point',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="检测点位数")
	private Long check_point;
//	{label: '超标点位数',name: 'check_point_out',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="超标点位数")
	private Long check_point_out;
//	{label: '超标率',name: 'check_out_rate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="超标率, 带2位小数")
	private String check_out_rate;

	//职业健康监护开展情况
//	{label: '已开展企业数',name: 'tutelage_companyCount',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="已开展企业数")
	private Long tutelage_companyCount;
//	{label: '开展率',name: 'tutelage_rate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="开展率, 带2位小数")
	private String tutelage_rate;
//	{label: '体检人数',name: 'tutelage_checkUpCount',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="体检人数")
	private Long tutelage_checkUpCount;
//	{label: '异常人数',name: 'tutelage_checkUp_exceptionCount',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="异常人数")
	private Long tutelage_checkUp_exceptionCount;
//	{label: '异常率',name: 'tutelage_checkUp_exception_rate',width: 60,summaryType:'sum', summaryTpl:'<b>{0}</b>'},
	@ApiModelProperty(value="异常率, 带2位小数")
	private String tutelage_checkUp_exception_rate;
}
